/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.setup.registry;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class EntitySubPredicatesRegistry {
    public static final DeferredRegister<MapCodec<? extends EntitySubPredicate>> ENTITY_SUB_PREDICATES = DeferredRegister.create((ResourceKey)Registries.ENTITY_SUB_PREDICATE_TYPE, (String)"ars_nouveau");
    public static final DeferredHolder<MapCodec<? extends EntitySubPredicate>, MapCodec<PercentHealthEqualOrLowerPredicate>> PERCENT_HEALTH_EQUAL_OR_LOWER = ENTITY_SUB_PREDICATES.register("percent_health_equal_or_lower", () -> PercentHealthEqualOrLowerPredicate.CODEC);

    public record PercentHealthEqualOrLowerPredicate(float threshold) implements EntitySubPredicate
    {
        public static final MapCodec<PercentHealthEqualOrLowerPredicate> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.fieldOf("threshold").forGetter(i -> Float.valueOf(i.threshold))).apply((Applicative)instance, PercentHealthEqualOrLowerPredicate::new));

        public MapCodec<PercentHealthEqualOrLowerPredicate> codec() {
            return CODEC;
        }

        public boolean matches(Entity entity, ServerLevel level, @Nullable Vec3 position) {
            LivingEntity livingEntity;
            return entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).getHealth() / livingEntity.getMaxHealth() <= this.threshold;
        }
    }
}

